<?php

namespace App\View\Components\Frontend\Global;

use App\Models\Package;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class Packages extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct(
        public int $limit = 6,
        public string $title = 'Our Packages',
        public string $subtitle = 'Check out our latest packages'
    ) {
        //
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        $packages = Package::where('status', true)->limit($this->limit)->get();

        return view('components.frontend.global.packages', compact('packages'));
    }
}
